/*
 * Decompiled with CFR 0.152.
 */
package si.quibi.net.hitrotiskanje.pdf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.prefs.Preferences;
import org.json.JSONObject;
import si.quibi.net.hitrotiskanje.App;
import si.quibi.net.hitrotiskanje.JSONUtils;
import si.quibi.net.hitrotiskanje.restserver.Nalepka;
import si.quibi.net.hitrotiskanje.restserver.NalepkaResponse;

public class GetZPL {
    final String API_ZPL_URL = "/api2/nalepke/zplopen";
    Preferences prefs = Preferences.userNodeForPackage(App.class);
    private Nalepka nalepka;
    private NalepkaResponse nalepkaResponse;
    final String QUIBIURL = "quibi_url";
    final String QUIBISSL = "quibi_ssl";

    public GetZPL(Nalepka nalepka) {
        this.nalepka = nalepka;
        this.nalepkaResponse = new NalepkaResponse();
    }

    public NalepkaResponse Download() throws IOException {
        URL url = null;
        try {
            url = this.prefs.get("quibi_ssl", "1").compareTo("1") == 0 ? new URI("https://" + this.prefs.get("quibi_url", "si.quibi.net") + "/api2/nalepke/zplopen/" + this.nalepka.getId() + "/" + this.nalepka.getModel() + "/" + this.nalepka.getGeslo()).toURL() : new URI("http://" + this.prefs.get("quibi_url", "si.quibi.net") + "/api2/nalepke/zplopen/" + this.nalepka.getId() + "/" + this.nalepka.getModel() + "/" + this.nalepka.getGeslo()).toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setUseCaches(false);
        httpConn.setDefaultUseCaches(false);
        httpConn.setRequestMethod("POST");
        httpConn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        JSONObject json = new JSONObject();
        JSONObject nalepke = new JSONObject();
        JSONObject vrstice = new JSONObject();
        nalepke.put("id", (Object)Integer.toString(this.nalepka.getNalepkaId()));
        nalepke.put("kolicina", (Object)Integer.toString(this.nalepka.getKolicina()));
        nalepke.put("dodatnopolje", (Object)this.nalepka.getDodatnoPolje());
        json.put("Nalepke", (Object)nalepke);
        for (Map.Entry<String, Integer> entry : this.nalepka.vrstice.entrySet()) {
            vrstice.put(entry.getKey(), (Object)new JSONObject().put("kolicina", (Object)entry.getValue()));
        }
        json.put("Vrstica", (Object)vrstice);
        String input = json.toString();
        OutputStream os = httpConn.getOutputStream();
        os.write(input.getBytes());
        os.flush();
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            if (httpConn.getContentType().startsWith("text/html")) {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                if (JSONUtils.isJSONValid(response.toString())) {
                    this.nalepkaResponse.setError(true);
                    this.nalepkaResponse.setMessage(response.toString());
                } else {
                    this.nalepkaResponse.setNalepka(response.toString());
                }
            } else {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                this.nalepkaResponse.setError(true);
                this.nalepkaResponse.setMessage(response.toString());
            }
        } else {
            this.nalepkaResponse.setError(true);
            this.nalepkaResponse.setMessage("Error! Server replied with HTTP code: " + responseCode);
        }
        httpConn.disconnect();
        return this.nalepkaResponse;
    }
}

