/*
 * Decompiled with CFR 0.152.
 */
package si.quibi.net.hitrotiskanje.pdf;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.util.prefs.Preferences;
import si.quibi.net.hitrotiskanje.App;
import si.quibi.net.hitrotiskanje.restserver.Dokument;
import si.quibi.net.hitrotiskanje.restserver.DokumentResponse;

public class GetPDF {
    final String API_PDF_URL = "/api2/glavadokumenta/pdfopen";
    private static final int BUFFER_SIZE = 4096;
    Preferences prefs = Preferences.userNodeForPackage(App.class);
    private Dokument dokument;
    private DokumentResponse dokumentResponse;
    final String QUIBIURL = "quibi_url";
    final String QUIBISSL = "quibi_ssl";

    public GetPDF(Dokument dokument) {
        this.dokument = dokument;
        this.dokumentResponse = new DokumentResponse(dokument.id, dokument.enostavniracun);
        System.out.println(this.prefs.get("quibi_url", "si.quibi.net"));
        System.out.println(this.prefs.get("quibi_ssl", "1"));
    }

    public DokumentResponse Download() throws IOException {
        URL url = null;
        String ssl = "https://";
        ssl = this.prefs.get("quibi_ssl", "1").compareTo("1") == 0 ? "https://" : "http://";
        try {
            url = new URI(ssl + this.prefs.get("quibi_url", "si.quibi.net") + "/api2/glavadokumenta/pdfopen/" + this.dokument.getId() + "/" + this.dokument.getGeslo() + "/" + this.dokument.getJezik() + "/" + this.dokument.isUpn()).toURL();
            System.out.println(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setDoOutput(true);
        httpConn.setDoInput(true);
        httpConn.setUseCaches(false);
        httpConn.setDefaultUseCaches(false);
        httpConn.setRequestMethod("GET");
        httpConn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            String saveDir = System.getProperty("java.io.tmpdir");
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            String fileName = "Dokument_" + Integer.toString(this.dokument.getId()) + "_" + Long.toString(timestamp.getTime()) + ".pdf";
            String disposition = httpConn.getHeaderField("Content-Disposition");
            String contentType = httpConn.getContentType();
            int contentLength = httpConn.getContentLength();
            System.out.println("Content-Type = " + contentType);
            System.out.println("Content-Disposition = " + disposition);
            System.out.println("Content-Length = " + contentLength);
            System.out.println("fileName = " + fileName);
            if (!httpConn.getContentType().startsWith("text/html")) {
                InputStream inputStream = httpConn.getInputStream();
                String saveFilePath = saveDir + File.separator + fileName;
                FileOutputStream outputStream = new FileOutputStream(saveFilePath);
                int bytesRead = -1;
                byte[] buffer = new byte[4096];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                this.dokumentResponse.setDatoteka(fileName);
            } else {
                String inputLine;
                BufferedReader in = new BufferedReader(new InputStreamReader(httpConn.getInputStream()));
                StringBuffer response = new StringBuffer();
                while ((inputLine = in.readLine()) != null) {
                    response.append(inputLine);
                }
                in.close();
                this.dokumentResponse.setError(true);
                this.dokumentResponse.setMessage(response.toString());
            }
        } else {
            this.dokumentResponse.setError(true);
            this.dokumentResponse.setMessage("No file to download. Server replied HTTP code: " + responseCode);
        }
        httpConn.disconnect();
        return this.dokumentResponse;
    }
}

