/*
 * Decompiled with CFR 0.152.
 */
package si.quibi.net.hitrotiskanje.pdf;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.prefs.Preferences;
import si.quibi.net.hitrotiskanje.App;
import si.quibi.net.hitrotiskanje.JSONUtils;
import si.quibi.net.hitrotiskanje.restserver.Escpos;
import si.quibi.net.hitrotiskanje.restserver.EscposResponse;

public class GetEscpos {
    final String API_ZPL_URL = "/api2/glavadokumenta/escposopen";
    Preferences prefs = Preferences.userNodeForPackage(App.class);
    private Escpos escpos;
    private EscposResponse escposResponse;
    final String QUIBIURL = "quibi_url";
    final String QUIBISSL = "quibi_ssl";

    public GetEscpos(Escpos escpos) {
        this.escpos = escpos;
        this.escposResponse = new EscposResponse();
    }

    public EscposResponse Download() throws IOException {
        URL url = null;
        String ssl = "https://";
        ssl = this.prefs.get("quibi_ssl", "1").compareTo("1") == 0 ? "https://" : "http://";
        try {
            url = new URI(ssl + this.prefs.get("quibi_url", "si.quibi.net") + "/api2/glavadokumenta/escposopen/" + this.escpos.getId() + "/" + this.escpos.getGeslo()).toURL();
            System.out.println(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        HttpURLConnection httpConn = (HttpURLConnection)url.openConnection();
        httpConn.setRequestMethod("GET");
        httpConn.setRequestProperty("User-Agent", "Quibi hitro tiskanje");
        httpConn.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
        int responseCode = httpConn.getResponseCode();
        if (responseCode == 200) {
            String inputLine;
            BufferedReader in = new BufferedReader(new InputStreamReader(httpConn.getInputStream(), "UTF-8"));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
                response.append("\n");
            }
            in.close();
            if (JSONUtils.isJSONValid(response.toString())) {
                this.escposResponse.setError(true);
                this.escposResponse.setMessage(response.toString());
            } else {
                this.escposResponse.setMessage(response.toString());
            }
        } else {
            this.escposResponse.setError(true);
            this.escposResponse.setMessage("Error! Server replied with HTTP code: " + responseCode);
        }
        httpConn.disconnect();
        return this.escposResponse;
    }
}

