/*
 * Decompiled with CFR 0.152.
 */
package si.quibi.net.hitrotiskanje;

import com.github.anastaciocintra.escpos.EscPos;
import com.github.anastaciocintra.escpos.EscPosConst;
import com.github.anastaciocintra.escpos.barcode.BarCode;
import com.github.anastaciocintra.escpos.barcode.BarCodeWrapperInterface;
import com.github.anastaciocintra.escpos.barcode.QRCode;
import com.github.anastaciocintra.output.PrinterOutputStream;
import com.google.common.base.Splitter;
import io.javalin.Javalin;
import io.javalin.http.Context;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.SimpleDoc;
import javax.print.event.PrintJobAdapter;
import javax.print.event.PrintJobEvent;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import net.miginfocom.swing.MigLayout;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.apache.pdfbox.printing.PDFPageable;
import org.apache.pdfbox.printing.PDFPrintable;
import org.apache.pdfbox.printing.Scaling;
import org.apache.pdfbox.rendering.PDFRenderer;
import si.quibi.net.hitrotiskanje.Item;
import si.quibi.net.hitrotiskanje.pdf.GetEscpos;
import si.quibi.net.hitrotiskanje.pdf.GetPDF;
import si.quibi.net.hitrotiskanje.pdf.GetZPL;
import si.quibi.net.hitrotiskanje.restserver.Dokument;
import si.quibi.net.hitrotiskanje.restserver.DokumentResponse;
import si.quibi.net.hitrotiskanje.restserver.Escpos;
import si.quibi.net.hitrotiskanje.restserver.EscposResponse;
import si.quibi.net.hitrotiskanje.restserver.Nalepka;
import si.quibi.net.hitrotiskanje.restserver.NalepkaResponse;

public class App {
    private JFrame frmQuibiHitroTiskanje;
    private static JTextPane tpLog;
    static final String A4TISKALNIK = "a4_tiskalnik";
    static final String POSTISKALNIK = "pos_tiskalnik";
    static final String ESCPOSTISKALNIK = "escpos_tiskalnik";
    static final String ESCPOSTISKALNIKKODA = "escpos_tiskalnik_koda";
    static final String ESCPOSTISKALNIKKODAST = "escpos_tiskalnik_stkod";
    static final String LABELTISKALNIK = "label_tiskalnik";
    static final String QUIBIURL = "quibi_url";
    static String[] tiskalniki;
    static Preferences prefs;
    TrayIcon trayIcon;
    SystemTray tray;

    static {
        prefs = Preferences.userNodeForPackage(App.class);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    App window = new App();
                    window.frmQuibiHitroTiskanje.setVisible(true);
                    window.frmQuibiHitroTiskanje.setState(1);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public App() throws IOException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (UnsupportedLookAndFeelException e) {
            e.printStackTrace();
        }
        App.ListPrinters();
        this.initialize();
        this.AddToTray();
        this.PozeniWebServer();
    }

    private void AddToTray() throws IOException {
        if (SystemTray.isSupported()) {
            System.out.println("system tray supported");
            this.tray = SystemTray.getSystemTray();
            BufferedImage image = ImageIO.read(this.getClass().getResource("/quibi-ikona.png"));
            ActionListener exitListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    System.out.println("Exiting....");
                    System.exit(0);
                }
            };
            PopupMenu popup = new PopupMenu();
            MenuItem defaultItem = new MenuItem("Izhod");
            defaultItem.addActionListener(exitListener);
            popup.add(defaultItem);
            defaultItem = new MenuItem("Odpri Quibi hitro tiskanje");
            defaultItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    App.this.frmQuibiHitroTiskanje.setVisible(true);
                    App.this.frmQuibiHitroTiskanje.setExtendedState(0);
                }
            });
            popup.add(defaultItem);
            this.trayIcon = new TrayIcon(image, "Quibi hitro tiskanje", popup);
            this.trayIcon.setImageAutoSize(true);
        } else {
            System.out.println("system tray not supported");
        }
    }

    private void initialize() throws IOException {
        this.frmQuibiHitroTiskanje = new JFrame();
        this.frmQuibiHitroTiskanje.setIconImage(ImageIO.read(this.getClass().getResource("/quibi-ikona.png")));
        this.frmQuibiHitroTiskanje.addWindowStateListener(new WindowStateListener(){

            @Override
            public void windowStateChanged(WindowEvent e) {
                if (e.getNewState() == 1 && SystemTray.isSupported()) {
                    try {
                        App.this.tray.add(App.this.trayIcon);
                        App.this.frmQuibiHitroTiskanje.setVisible(false);
                        System.out.println("added to SystemTray");
                    }
                    catch (AWTException ex) {
                        System.out.println("unable to add to tray");
                    }
                }
                if (e.getNewState() == 7) {
                    try {
                        App.this.tray.add(App.this.trayIcon);
                        App.this.frmQuibiHitroTiskanje.setVisible(false);
                        System.out.println("added to SystemTray");
                    }
                    catch (AWTException ex) {
                        System.out.println("unable to add to system tray");
                    }
                }
                if (e.getNewState() == 6) {
                    App.this.tray.remove(App.this.trayIcon);
                    App.this.frmQuibiHitroTiskanje.setVisible(true);
                    System.out.println("Tray icon removed");
                }
                if (e.getNewState() == 0 && SystemTray.isSupported()) {
                    App.this.tray.remove(App.this.trayIcon);
                    App.this.frmQuibiHitroTiskanje.setVisible(true);
                    System.out.println("Tray icon removed");
                }
            }
        });
        this.frmQuibiHitroTiskanje.setTitle("Quibi hitro tiskanje");
        this.frmQuibiHitroTiskanje.setBounds(100, 100, 523, 622);
        this.frmQuibiHitroTiskanje.setDefaultCloseOperation(3);
        tpLog = new JTextPane();
        JMenuBar menuBar = new JMenuBar();
        this.frmQuibiHitroTiskanje.setJMenuBar(menuBar);
        JMenu mnDatoteka = new JMenu("Datoteka");
        menuBar.add(mnDatoteka);
        JMenu mnIzhod = new JMenu("Izhod");
        mnIzhod.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                System.exit(0);
            }
        });
        mnDatoteka.add(mnIzhod);
        JMenu mnZebra = new JMenu("Mo\u017enosti");
        menuBar.add(mnZebra);
        JMenu mnZebraTest = new JMenu("Zebra test");
        mnZebraTest.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                tpLog.setText(tpLog.getText() + "Tiskam test na Zebro\n");
                App.PrintZPLII("^XA\n^CI28\n^PW300\n^FO10,10^A0,20^FD Quibi - \u010d\u017e\u0161\u010c\u017d\u0160^FS\n^BY2,2,40\n^FO10,40^BC^FD12345678^FS\n^XZ");
            }
        });
        mnZebra.add(mnZebraTest);
        JMenu mnEscPosTest = new JMenu("ESC/POS test");
        mnEscPosTest.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                tpLog.setText(tpLog.getText() + "Tiskam test na ESC/POS\n");
                PrintService printService = App.findPrintService(prefs.get(App.ESCPOSTISKALNIK, ""));
                if (printService == null) {
                    tpLog.setText(tpLog.getText() + "Izberite ESC/POS tiskalnik!\n");
                } else {
                    try {
                        EscPos escpos = new EscPos((OutputStream)new PrinterOutputStream(printService));
                        escpos.setCharacterCodeTable(EscPos.CharacterCodeTable.CP852_Latin2);
                        escpos.writeLF("Quibi hitro tiskanje");
                        escpos.writeLF("Test \u0161umnikov: \u010d\u017e\u0161\u010c\u017d\u0160");
                        escpos.feed(2);
                        if (prefs.getInt(App.ESCPOSTISKALNIKKODA, 1) == 1) {
                            QRCode qrcode = new QRCode();
                            qrcode.setSize(5);
                            qrcode.setJustification(EscPosConst.Justification.Center);
                            escpos.write((BarCodeWrapperInterface)qrcode, "https://www.quibi.net");
                        }
                        if (prefs.getInt(App.ESCPOSTISKALNIKKODA, 1) == 2) {
                            String testnaKoda = "223175087923687075112234402528973166755123456781508151013321";
                            int stCrk = 60 / prefs.getInt(App.ESCPOSTISKALNIKKODAST, 2);
                            Iterable result = Splitter.fixedLength((int)stCrk).split((CharSequence)testnaKoda);
                            int poz = 1;
                            String st4 = "{A4";
                            if (prefs.getInt(App.ESCPOSTISKALNIKKODAST, 2) == 4) {
                                st4 = "{A44";
                            }
                            BarCode barcode = new BarCode();
                            barcode.setSystem(BarCode.BarCodeSystem.CODE128);
                            barcode.setBarCodeSize(2, 40);
                            for (String s : result) {
                                escpos.write((BarCodeWrapperInterface)barcode, st4 + Integer.toString(poz) + s);
                                escpos.feed(1);
                                ++poz;
                            }
                        }
                        escpos.feed(5).cut(EscPos.CutMode.FULL);
                        escpos.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        tpLog.setText(tpLog.getText() + "Napaka pri tiskanju na ESC/POS!\n");
                    }
                }
            }
        });
        mnZebra.add(mnEscPosTest);
        this.frmQuibiHitroTiskanje.getContentPane().setLayout((LayoutManager)new MigLayout("", "[150px:n:150px,grow][grow]", "[][][][][][][][][][][300px:n,grow]"));
        JLabel lblNewLabel = new JLabel("A4 tiskalnik");
        this.frmQuibiHitroTiskanje.getContentPane().add((Component)lblNewLabel, "cell 0 0,alignx trailing");
        JComboBox<String> cbA4 = new JComboBox<String>(tiskalniki);
        cbA4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JComboBox combo = (JComboBox)event.getSource();
                String selected = (String)combo.getSelectedItem();
                try {
                    prefs.put(App.A4TISKALNIK, selected);
                    prefs.flush();
                    tpLog.setText(tpLog.getText() + "A4 tiskalnik nastavljen na: " + selected + "\n");
                }
                catch (BackingStoreException e) {
                    tpLog.setText(tpLog.getText() + "Napaka pri shranjevanju nastavitev!\n");
                }
            }
        });
        cbA4.setSelectedItem(prefs.get(A4TISKALNIK, ""));
        this.frmQuibiHitroTiskanje.getContentPane().add(cbA4, "cell 1 0,growx");
        JLabel lblNewLabel_1 = new JLabel("POS tiskalnik");
        this.frmQuibiHitroTiskanje.getContentPane().add((Component)lblNewLabel_1, "cell 0 1,alignx trailing");
        JComboBox<String> cbPos = new JComboBox<String>(tiskalniki);
        cbPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JComboBox combo = (JComboBox)event.getSource();
                String selected = (String)combo.getSelectedItem();
                try {
                    prefs.put(App.POSTISKALNIK, selected);
                    prefs.flush();
                    tpLog.setText(tpLog.getText() + "POS tiskalnik nastavljen na: " + selected + "\n");
                }
                catch (BackingStoreException e) {
                    tpLog.setText(tpLog.getText() + "Napaka pri shranjevanju nastavitev!\n");
                }
            }
        });
        cbPos.setSelectedItem(prefs.get(POSTISKALNIK, ""));
        this.frmQuibiHitroTiskanje.getContentPane().add(cbPos, "cell 1 1,growx");
        JLabel lblNewLabel_2 = new JLabel("ESC/POS tiskalnik");
        this.frmQuibiHitroTiskanje.getContentPane().add((Component)lblNewLabel_2, "cell 0 2,alignx trailing");
        JComboBox<String> cbEscPos = new JComboBox<String>(tiskalniki);
        cbEscPos.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JComboBox combo = (JComboBox)event.getSource();
                String selected = (String)combo.getSelectedItem();
                try {
                    prefs.put(App.ESCPOSTISKALNIK, selected);
                    prefs.flush();
                    tpLog.setText(tpLog.getText() + "ESC/POS tiskalnik nastavljen na: " + selected + "\n");
                }
                catch (BackingStoreException e) {
                    tpLog.setText(tpLog.getText() + "Napaka pri shranjevanju nastavitev!\n");
                }
            }
        });
        cbEscPos.setSelectedItem(prefs.get(ESCPOSTISKALNIK, ""));
        this.frmQuibiHitroTiskanje.getContentPane().add(cbEscPos, "cell 1 2,growx");
        JLabel lblKoda = new JLabel("Tiskaj kodo kot");
        this.frmQuibiHitroTiskanje.getContentPane().add((Component)lblKoda, "cell 0 3,alignx trailing");
        JComboBox<Item> cbEscPosKoda = new JComboBox<Item>();
        cbEscPosKoda.addItem(new Item(1, "QR"));
        cbEscPosKoda.addItem(new Item(2, "CODE128"));
        cbEscPosKoda.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JComboBox combo = (JComboBox)event.getSource();
                Item selected = (Item)combo.getSelectedItem();
                try {
                    prefs.putInt(App.ESCPOSTISKALNIKKODA, selected.getId());
                    prefs.flush();
                    tpLog.setText(tpLog.getText() + "ESC/POS tiskalnik tikanje kode nastavljen na: " + selected.getDescription() + "\n");
                }
                catch (BackingStoreException e) {
                    tpLog.setText(tpLog.getText() + "Napaka pri shranjevanju nastavitev!\n");
                }
            }
        });
        int c = 0;
        while (c < cbEscPosKoda.getItemCount()) {
            Item item = (Item)cbEscPosKoda.getItemAt(c);
            if (item.getId() == prefs.getInt(ESCPOSTISKALNIKKODA, 1)) {
                cbEscPosKoda.setSelectedItem(item);
            }
            ++c;
        }
        this.frmQuibiHitroTiskanje.getContentPane().add(cbEscPosKoda, "cell 1 3,growx");
        JLabel lblStKod = new JLabel("Tiskaj \u0161t. CODE128");
        this.frmQuibiHitroTiskanje.getContentPane().add((Component)lblStKod, "cell 0 4,alignx trailing");
        JComboBox<Item> cbEscPosStKod = new JComboBox<Item>();
        cbEscPosStKod.addItem(new Item(2, "2"));
        cbEscPosStKod.addItem(new Item(3, "3"));
        cbEscPosStKod.addItem(new Item(4, "4"));
        cbEscPosStKod.addItem(new Item(5, "5"));
        cbEscPosStKod.addItem(new Item(6, "6"));
        cbEscPosStKod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JComboBox combo = (JComboBox)event.getSource();
                Item selected = (Item)combo.getSelectedItem();
                try {
                    prefs.putInt(App.ESCPOSTISKALNIKKODAST, selected.getId());
                    prefs.flush();
                    tpLog.setText(tpLog.getText() + "ESC/POS tiskalnik tikanje \u0161t. kod nastavljen na: " + selected.getDescription() + "\n");
                }
                catch (BackingStoreException e) {
                    tpLog.setText(tpLog.getText() + "Napaka pri shranjevanju nastavitev!\n");
                }
            }
        });
        int c2 = 0;
        while (c2 < cbEscPosStKod.getItemCount()) {
            Item item = (Item)cbEscPosStKod.getItemAt(c2);
            if (item.getId() == prefs.getInt(ESCPOSTISKALNIKKODAST, 2)) {
                cbEscPosStKod.setSelectedItem(item);
            }
            ++c2;
        }
        this.frmQuibiHitroTiskanje.getContentPane().add(cbEscPosStKod, "cell 1 4,growx");
        JLabel lblTiskalnikNalepk = new JLabel("Tiskalnik nalepk");
        this.frmQuibiHitroTiskanje.getContentPane().add((Component)lblTiskalnikNalepk, "cell 0 5,alignx trailing");
        JComboBox<String> cbNalepke = new JComboBox<String>(tiskalniki);
        cbNalepke.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JComboBox combo = (JComboBox)event.getSource();
                String selected = (String)combo.getSelectedItem();
                try {
                    prefs.put(App.LABELTISKALNIK, selected);
                    prefs.flush();
                    tpLog.setText(tpLog.getText() + "Tiskalnik nalepk nastavljen na: " + selected + "\n");
                }
                catch (BackingStoreException e) {
                    tpLog.setText(tpLog.getText() + "Napaka pri shranjevanju nastavitev!\n");
                }
            }
        });
        cbNalepke.setSelectedItem(prefs.get(LABELTISKALNIK, ""));
        this.frmQuibiHitroTiskanje.getContentPane().add(cbNalepke, "cell 1 5,growx");
        tpLog.setEditable(false);
        tpLog.setAutoscrolls(true);
        this.frmQuibiHitroTiskanje.getContentPane().add((Component)tpLog, "flowy,cell 0 9 2 1,grow");
    }

    public static void ListPrinters() {
        PrintService[] allPrinters = PrintServiceLookup.lookupPrintServices(null, null);
        tiskalniki = new String[allPrinters.length + 1];
        App.tiskalniki[0] = "";
        int i = 1;
        PrintService[] printServiceArray = allPrinters;
        int n = allPrinters.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService printer = printServiceArray[n2];
            App.tiskalniki[i] = printer.getName();
            ++i;
            ++n2;
        }
    }

    private void PozeniWebServer() {
        Javalin app = Javalin.create(config -> config.enableCorsForAllOrigins()).events(event -> {
            event.serverStarting(() -> {
                tpLog.setText(tpLog.getText() + "Za\u010dasne datoteke: " + System.getProperty("java.io.tmpdir") + "\n");
                tpLog.setText(tpLog.getText() + "URL: " + prefs.get(QUIBIURL, "si.quibi.net") + "\n");
                tpLog.setText(tpLog.getText() + "Poganjam stre\u017enik.\n");
            });
            event.serverStarted(() -> tpLog.setText(tpLog.getText() + "Stre\u017enik je pognan.\n"));
            event.serverStartFailed(() -> tpLog.setText(tpLog.getText() + "Pri\u0161lo je do napake! Stre\u017enik ni pognan.\n"));
            event.serverStopping(() -> tpLog.setText(tpLog.getText() + "Ustavljam stre\u017enik.\n"));
            event.serverStopped(() -> tpLog.setText(tpLog.getText() + "Stre\u017enik ustavljen.\n"));
        }).start(7000);
        app.get("/", ctx -> {
            Context context = ctx.result("Quibi hitro tiskanje!");
        });
        app.get("/dokument/:id/:enostavniracun/:jezik/:upn/:geslo", ctx -> {
            boolean enostavniracun = false;
            boolean upn = false;
            if (ctx.pathParam("enostavniracun").equals("1")) {
                enostavniracun = true;
            }
            if (ctx.pathParam("upn").equals("1")) {
                upn = true;
            }
            Dokument dokument = new Dokument(Integer.parseInt(ctx.pathParam("id")), enostavniracun, ctx.pathParam("jezik"), upn, ctx.pathParam("geslo"));
            System.out.println(dokument.toString());
            GetPDF getPDF = new GetPDF(dokument);
            DokumentResponse dokumentResponse = getPDF.Download();
            if (dokumentResponse.isError()) {
                tpLog.setText(tpLog.getText() + "[NAPAKA] " + dokumentResponse.getMessage() + "\n");
            } else {
                tpLog.setText(tpLog.getText() + "Prejel sem datoteko: " + dokumentResponse.getDatoteka() + "\n");
                App.PrintDocument(dokumentResponse);
            }
            ctx.json((Object)dokument);
        });
        app.get("/escpos/:id/:geslo", ctx -> {
            tpLog.setText(tpLog.getText() + "Po\u0161iljam zahtevek za ESC/POS sekvenco.\n");
            Escpos escpos = new Escpos(Integer.parseInt(ctx.pathParam("id")), ctx.pathParam("geslo"));
            System.out.println(escpos.toString());
            long startTime = System.currentTimeMillis();
            GetEscpos getEscpos = new GetEscpos(escpos);
            EscposResponse escposResponse = getEscpos.Download();
            long endTime = System.currentTimeMillis();
            System.out.println("That took " + (endTime - startTime) + " milliseconds");
            if (escposResponse.isError()) {
                tpLog.setText(tpLog.getText() + "[NAPAKA] " + escposResponse.getMessage() + "\n");
            } else {
                App.PrintEscpos(escposResponse.getMessage());
            }
            ctx.json((Object)escpos);
        });
        app.post("/nalepke/zpl/:id/:model/:geslo", ctx -> {
            Nalepka nalepka = new Nalepka(Integer.parseInt(ctx.pathParam("id")), ctx.pathParam("model"), Integer.parseInt(ctx.formParam("data[Nalepke][naziv]")), Integer.parseInt(ctx.formParam("data[Nalepke][kolicina]")), ctx.formParam("data[Nalepke][dodatnopolje]"), ctx.pathParam("geslo"));
            Pattern pattern = Pattern.compile("data\\[Vrstica\\]\\[\\d*\\]\\[kolicina\\]", 2);
            Pattern patternId = Pattern.compile("\\d+", 2);
            Iterator iter = ctx.formParamMap().entrySet().iterator();
            iter.forEachRemaining(it -> {
                Matcher matcherId;
                Matcher matcher = pattern.matcher((CharSequence)it.getKey());
                if (matcher.find() && (matcherId = patternId.matcher((CharSequence)it.getKey())).find()) {
                    nalepka.addVrstica(matcherId.group(), Integer.parseInt(ctx.formParam((String)it.getKey())));
                }
            });
            GetZPL getZPL = new GetZPL(nalepka);
            NalepkaResponse nalepkaResponse = getZPL.Download();
            if (nalepkaResponse.isError()) {
                tpLog.setText(tpLog.getText() + "[NAPAKA] " + nalepkaResponse.getMessage() + "\n");
            } else {
                tpLog.setText(tpLog.getText() + "Prejel sem nalepko - tiskam.\n");
                App.PrintZPLII(nalepkaResponse.getNalepka());
            }
            ctx.json((Object)nalepka);
        });
    }

    private static void preheatRenderer(PDDocument document) throws IOException {
        PDFRenderer renderer = new PDFRenderer(document);
        renderer.renderImageWithDPI(0, 300.0f);
    }

    private static void PrintDocument(DokumentResponse dokumentResponse) throws InvalidPasswordException, IOException, PrinterException {
        String saveDir = System.getProperty("java.io.tmpdir");
        PDDocument document = Loader.loadPDF((File)new File(saveDir + File.separator + dokumentResponse.getDatoteka()));
        PrintService myPrintService = dokumentResponse.enostavniracun ? App.findPrintService(prefs.get(POSTISKALNIK, "")) : App.findPrintService(prefs.get(A4TISKALNIK, ""));
        try {
            try {
                App.preheatRenderer(document);
                PrinterJob job = PrinterJob.getPrinterJob();
                job.setPrintService(myPrintService);
                if (dokumentResponse.enostavniracun) {
                    PDFPrintable printable = new PDFPrintable(document, Scaling.SCALE_TO_FIT);
                    job.setPrintable((Printable)printable);
                    App.setupPageFormat(document, job);
                } else {
                    job.setPageable((Pageable)new PDFPageable(document));
                }
                job.setJobName(dokumentResponse.getDatoteka());
                job.print();
            }
            catch (Exception e) {
                App.logError("Napaka! Dokumenta ni mogo\u010de natisniti.", e);
                document.close();
                tpLog.setText(tpLog.getText() + "Sem zaprl dokument.\n");
            }
        }
        finally {
            document.close();
            tpLog.setText(tpLog.getText() + "Sem zaprl dokument.\n");
        }
    }

    private static void setupPageFormat(PDDocument document, PrinterJob job) {
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(1);
        Paper p = pageFormat.getPaper();
        p.setSize(document.getPage(0).getMediaBox().getWidth(), document.getPage(0).getMediaBox().getHeight());
        p.setImageableArea(0.0, 0.0, p.getWidth(), p.getHeight());
        pageFormat.setPaper(p);
        try {
            PDFPrintable printable = new PDFPrintable(document, Scaling.SCALE_TO_FIT);
            job.setPrintable((Printable)printable, pageFormat);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void logError(String message, Exception e) {
        tpLog.setText(tpLog.getText() + message + "\n");
        tpLog.setText(tpLog.getText() + "Detail: " + e.getLocalizedMessage() + "\n");
    }

    private static void PrintEscpos(String s) {
        long startTime = System.currentTimeMillis();
        long ztiskanja = System.currentTimeMillis();
        PrintService myPrintService = App.findPrintService(prefs.get(ESCPOSTISKALNIK, ""));
        long endTime = System.currentTimeMillis();
        System.out.println("Iskanje tiskalnika: " + (endTime - startTime) + " milliseconds");
        if (myPrintService == null) {
            tpLog.setText(tpLog.getText() + "Izberite ESC/POS tiskalnik!\n");
            return;
        }
        String[] lines = s.split("\\r?\\n|\\r");
        try {
            startTime = System.currentTimeMillis();
            PrinterOutputStream printerOutputStream = new PrinterOutputStream(myPrintService);
            endTime = System.currentTimeMillis();
            System.out.println("Povezava s tiskalnikom: " + (endTime - startTime) + " milliseconds");
            EscPos escpos = new EscPos((OutputStream)printerOutputStream);
            escpos.setCharacterCodeTable(EscPos.CharacterCodeTable.CP852_Latin2);
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String l = stringArray[n2];
                if (l.contains("QRKODA")) {
                    if (prefs.getInt(ESCPOSTISKALNIKKODA, 1) == 1) {
                        QRCode qrcode = new QRCode();
                        qrcode.setSize(5);
                        qrcode.setJustification(EscPosConst.Justification.Center);
                        escpos.write((BarCodeWrapperInterface)qrcode, l.substring(l.indexOf("QRKODA[") + 7, l.indexOf("]QRKODA")));
                    }
                    if (prefs.getInt(ESCPOSTISKALNIKKODA, 1) == 2) {
                        String testnaKoda = l.substring(l.indexOf("QRKODA[") + 7, l.indexOf("]QRKODA"));
                        int stCrk = 60 / prefs.getInt(ESCPOSTISKALNIKKODAST, 2);
                        Iterable result = Splitter.fixedLength((int)stCrk).split((CharSequence)testnaKoda);
                        int poz = 1;
                        String st4 = "{A4";
                        if (prefs.getInt(ESCPOSTISKALNIKKODAST, 2) == 4) {
                            st4 = "{A44";
                        }
                        BarCode barcode = new BarCode();
                        barcode.setSystem(BarCode.BarCodeSystem.CODE128);
                        barcode.setBarCodeSize(2, 40);
                        for (String ss : result) {
                            escpos.write((BarCodeWrapperInterface)barcode, st4 + Integer.toString(poz) + ss);
                            escpos.feed(1);
                            ++poz;
                        }
                    }
                } else {
                    escpos.writeLF(l);
                }
                ++n2;
            }
            escpos.feed(5).cut(EscPos.CutMode.FULL);
            escpos.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
            tpLog.setText(tpLog.getText() + "Napaka pri tiskanju na ESC/POS!\n");
        }
        long ktiskanja = System.currentTimeMillis();
        System.out.println("Trajanje tiskanja: " + (ktiskanja - ztiskanja) + " milliseconds");
    }

    private static void PrintZPLII(String s) {
        PrintService myPrintService = App.findPrintService(prefs.get(LABELTISKALNIK, ""));
        if (myPrintService == null) {
            tpLog.setText(tpLog.getText() + "Izberite tiskalnik!\n");
            return;
        }
        try {
            DocPrintJob job = myPrintService.createPrintJob();
            ByteArrayInputStream is = new ByteArrayInputStream(s.getBytes());
            DocFlavor.INPUT_STREAM flavor = DocFlavor.INPUT_STREAM.AUTOSENSE;
            SimpleDoc d = new SimpleDoc(is, flavor, null);
            PrintJobWatcher pjDone = new PrintJobWatcher(job);
            job.print(d, null);
            pjDone.waitForDone();
            ((InputStream)is).close();
        }
        catch (IOException | PrintException e) {
            e.printStackTrace();
        }
    }

    private static PrintService findPrintService(String printerName) {
        PrintService[] printServices;
        PrintService[] printServiceArray = printServices = PrintServiceLookup.lookupPrintServices(null, null);
        int n = printServices.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService printService = printServiceArray[n2];
            if (printService.getName().trim().equals(printerName)) {
                return printService;
            }
            ++n2;
        }
        return null;
    }

    static class PrintJobWatcher {
        boolean done = false;

        PrintJobWatcher(DocPrintJob job) {
            job.addPrintJobListener(new PrintJobAdapter(){

                @Override
                public void printJobCanceled(PrintJobEvent pje) {
                    this.allDone();
                }

                @Override
                public void printJobCompleted(PrintJobEvent pje) {
                    this.allDone();
                }

                @Override
                public void printJobFailed(PrintJobEvent pje) {
                    this.allDone();
                }

                @Override
                public void printJobNoMoreEvents(PrintJobEvent pje) {
                    this.allDone();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void allDone() {
                    PrintJobWatcher printJobWatcher = this;
                    synchronized (printJobWatcher) {
                        done = true;
                        this.notify();
                    }
                }
            });
        }

        public synchronized void waitForDone() {
            try {
                while (!this.done) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

